<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cookie;

class SetLocale
{
    /**
     * Handle an incoming request and ensure the locale is loaded and stored.
     */
    public function handle(Request $request, Closure $next)
    {
        $supported = config('app.supported_locales', [config('app.locale')]);
        $sessionLocale = $request->session()->get('locale');
        $cookieLocale = Cookie::get('locale');

        $locale = $sessionLocale
            ?? $cookieLocale
            ?? $request->getPreferredLanguage($supported)
            ?? config('app.locale');

        if (! in_array($locale, $supported, true)) {
            $locale = config('app.locale');
        }

        $request->session()->put('locale', $locale);
        app()->setLocale($locale);

        $response = $next($request);

        Cookie::queue(Cookie::make('locale', $locale, 525_600));

        return $response;
    }
}
