<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Auth\GenericUser;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class EnsureAdminAccess
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Prefer an already-authenticated admin user if available.
        $user = Auth::user();
        if ($user && ($user->is_admin ?? false)) {
            return $next($request);
        }

        $configuredUsername = config('admin.username');
        $configuredPassword = config('admin.password');

        $username = $request->getUser();
        $password = $request->getPassword();

        $valid = is_string($configuredPassword)
            && $username === $configuredUsername
            && hash_equals($configuredPassword, (string) $password);

        if (!$valid) {
            return response('Unauthorized.', 401, ['WWW-Authenticate' => 'Basic']);
        }

        Auth::setUser(new GenericUser([
            'id' => 1,
            'name' => 'Administrator',
            'email' => $configuredUsername,
            'is_admin' => true,
        ]));

        return $next($request);
    }
}