<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\JsonResponse; // استيراد نوع الإرجاع

class ThemeController extends Controller
{
    // 2. استخدام الثوابت لتعريف مفتاح الـ Session وأسماء السمات لزيادة الوضوح
    protected const SESSION_KEY = 'dark_mode';
    protected const DARK_THEME = 'dark';
    protected const LIGHT_THEME = 'light';

    /**
     * Toggles the dark mode state in the session and returns the new state.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function toggle(Request $request): JsonResponse
    {
        // 3. التحقق من القيمة الحالية، القيمة الافتراضية هي false (الوضع الفاتح)
        $isDarkMode = Session::get(self::SESSION_KEY, false);

        // تبديل الحالة
        $newDarkModeState = !$isDarkMode;

        // تحديث القيمة في الـ Session
        Session::put(self::SESSION_KEY, $newDarkModeState);

        // تحديد اسم السمة الجديدة (dark أو light)
        $themeName = $newDarkModeState ? self::DARK_THEME : self::LIGHT_THEME;

        // 1. تحديد نوع الإرجاع بشكل صريح
        return response()->json([
            'success' => true,
            'dark_mode' => $themeName,
            'is_dark_mode' => $newDarkModeState, // يمكن إضافة هذه القيمة لتسهيل التعامل معها في الواجهة الأمامية
        ]);
    }
}