<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Str;

class LocalizationController extends Controller
{
    /**
     * Switch the application language and redirect back to the previous page.
     *
     * يتم استدعاء هذه الدالة بواسطة المسار 'language.switch'
     *
     * @param string $locale The requested locale (e.g., 'en', 'ar', 'es').
     * @return \Illuminate\Http\RedirectResponse
     */
    public function switch(Request $request, ?string $locale = null)
    {
        $supportedLocales = config('app.supported_locales', ['en']);
        $locale = $locale ?? $request->input('locale');

        if (!in_array($locale, $supportedLocales, true)) {
            $locale = config('app.fallback_locale', config('app.locale', 'en'));
        }

        Session::put('locale', $locale);
        App::setLocale($locale);
        Cookie::queue(Cookie::make('locale', $locale, 525_600));

        $returnUrl = $request->input('return_url') ?? url()->previous() ?? route('home');
        $absoluteReturnUrl = Str::startsWith($returnUrl, ['http://', 'https://'])
            ? $returnUrl
            : url()->to($returnUrl);

        if (!str_starts_with($absoluteReturnUrl, url('/'))) {
            $absoluteReturnUrl = route('home');
        }

        return redirect()->to($absoluteReturnUrl);
    }
}
