<?php

namespace App\Http\Controllers;

use App\Services\ZipArchiveService;
use Illuminate\Support\Facades\Response;
use Illuminate\Http\Request;

class DownloadZipController extends Controller
{
    /**
     * Download a previously created ZIP archive from storage/temp-zips.
     */
    public function download(Request $request, string $file)
    {
        // Simple authorization check: only users with 'platform.export-zip' permission
        if (!auth()->check() || !auth()->user()->hasAccess('platform.export-zip')) {
            abort(403);
        }

        $zip = new ZipArchiveService();
        $path = $zip->getArchivePath($file);

        if (! $path) {
            abort(404);
        }

        return Response::download($path, $file, [
            'Content-Type' => 'application/zip',
        ]);
    }
}
