<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\App;
use App\Models\Category;
use Carbon\Carbon;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\View\View;

class DashboardController extends Controller
{
    /**
     * Show the admin overview dashboard for APK Center.
     */
    public function index(): View
    {
        $latestUpdate = App::active()->orderBy('updated_at', 'desc')->value('updated_at');

        $stats = [
            'apps' => App::active()->count(),
            'categories' => Category::active()->count(),
            'total_downloads' => App::sum('downloads_count'),
            'latest_update' => $latestUpdate ? Carbon::parse($latestUpdate) : null,
        ];

        return view('admin.dashboard', [
            'stats' => $stats,
            'importSources' => config('import_sources.sources', []),
        ]);
    }

    /**
     * Trigger the import command from the dashboard.
     */
    public function runImport(Request $request): RedirectResponse
    {
        $validated = $request->validate([
            'source' => 'nullable|string',
            'force' => 'sometimes|boolean',
        ]);

        $parameters = [];

        if (! empty($validated['source'])) {
            $parameters['--source'] = $validated['source'];
        }

        if (! empty($validated['force'])) {
            $parameters['--force'] = true;
        }

        Artisan::call('app:import-new', $parameters);

        return redirect()
            ->route('admin.dashboard')
            ->with('status', __('Import command queued. Check logs for details.'));
    }
}