<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;
use Illuminate\Auth\AuthenticationException;
use Filament\Facades\Filament;
use Illuminate\Support\Facades\Route;

class Handler extends ExceptionHandler
{
    /**
     * The list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    /**
     * Convert an authentication exception into a response.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Illuminate\Auth\AuthenticationException  $exception
     * @return \Symfony\Component\HttpFoundation\Response
     */
    protected function unauthenticated($request, AuthenticationException $exception)
    {
        // 1. إذا كان الطلب يتوقع JSON (مثل طلب API)، أعد 401
        if ($request->expectsJson()) {
            return response()->json(['message' => $exception->getMessage()], 401);
        }

        // 2. إذا كان الطلب موجهًا إلى لوحة إدارة Filament (الأهم)
        // هذا يضمن أن Laravel يحوّل إلى مسار Filament الصحيح: /admin/login
        if (Filament::getCurrentPanel()) {
            return redirect()->guest(
                Filament::getCurrentPanel()->getLoginUrl()
            );
        }
        
        // 3. السلوك الافتراضي (التحويل لصفحة تسجيل دخول أمامية)
        // نتحقق أولاً مما إذا كان مسار 'login' التقليدي موجودًا.
        if (Route::has('login')) {
            return redirect()->guest(route('login'));
        }
        
        // 4. إذا لم يكن هناك مسار تسجيل دخول تقليدي (وهي حالتك)،
        // نوجه إلى الصفحة الرئيسية 'home' بدلاً من إظهار خطأ الخادم.
        return redirect()->guest(route('home'));
    }
}