<?php

namespace App\Enums;

// يتطلب PHP 8.1 أو أحدث
enum VersionStatus: string
{
    // الإصدارات النشطة والمتاحة للتحميل
    case Active = 'active';

    // الإصدارات غير النشطة مؤقتاً (مخبأة)
    case Inactive = 'inactive';

    // الإصدارات التي لم يتم نشرها بعد
    case Draft = 'draft';

    // الإصدارات القديمة التي لم تعد مدعومة أو يُفضل عدم استخدامها
    case Deprecated = 'deprecated';

    /**
     * احصل على تسمية CSS/لون مناسب للحالة (للاستخدام في الواجهة الأمامية)
     */
    public function color(): string
    {
        return match ($this) {
            self::Active => 'green',
            self::Inactive => 'orange',
            self::Draft => 'gray',
            self::Deprecated => 'red',
        };
    }

    /**
     * احصل على تسمية عربية سهلة القراءة
     */
    public function label(): string
    {
        return match ($this) {
            self::Active => 'نشط',
            self::Inactive => 'غير نشط',
            self::Draft => 'مسودة',
            self::Deprecated => 'مهمل',
        };
    }
}