<?php

namespace App\Console\Commands;

use App\Services\SEOOptimizer;
use Illuminate\Console\Command;

class GenerateSitemap extends Command
{
    protected $signature = 'seo:generate-sitemap';
    protected $description = 'Generate XML sitemap for SEO';

    public function handle(): int
    {
        $this->info('Generating sitemap...');

        try {
            SEOOptimizer::saveSitemap();
            $this->info('✓ Sitemap generated successfully at public/sitemap.xml');
            return 0;
        } catch (\Exception $e) {
            $this->error('✗ Failed to generate sitemap: ' . $e->getMessage());
            return 1;
        }
    }
}
