# 🌐 Translation System - Quick Reference

## ⚡ Quick Commands

```bash
# Translate everything (recommended first time)
php artisan translate:strings

# Or use the bash script
./translate.sh

# Retranslate all (overwrite existing)
php artisan translate:strings --force

# Translate to specific languages only
php artisan translate:strings --targets=ar,es

# Translate from different source
php artisan translate:strings --source=ar --targets=en,es
```

## 📂 File Locations

```
resources/lang/
  en.json  ← English (source)
  ar.json  ← Arabic
  es.json  ← Spanish
  fr.json  ← French
  hi.json  ← Hindi
```

## 💻 Using in Blade

```blade
{# Simple translation #}
{{ __('Hello') }}

{# With parameters #}
{{ __('Welcome, :name', ['name' => 'John']) }}

{# In attributes #}
<button title="{{ __('Click me') }}">Button</button>

{# Plural forms #}
{{ trans_choice('items', $count) }}
```

## 📝 Adding New Strings

### 1. Add to en.json
```json
{
  "Hello": "Hello",
  "New Feature": "New Feature"
}
```

### 2. Use in template
```blade
{{ __('New Feature') }}
```

### 3. Run translation
```bash
php artisan translate:strings --targets=ar,es,fr,hi
```

## 🔧 Supported Options

| Flag | Purpose |
|------|---------|
| `--source=en` | Source language (default: en) |
| `--targets=ar,es` | Target languages (comma-separated) |
| `--force` | Retranslate everything (overwrites existing) |

## ⚙️ How It Works

1. Reads source language JSON file
2. Calls MyMemory API for each string
3. Waits 100ms between requests (rate limiting)
4. Saves translations back to JSON
5. Skips already-translated unless `--force`

## 🚀 Performance

- **150 strings** ≈ 15 seconds
- **300 strings** ≈ 30 seconds
- (Depends on network speed)

## ❌ Troubleshooting

| Problem | Solution |
|---------|----------|
| Command not found | Run: `chmod +x artisan` |
| PHP not found | Check PHP installation or use full path |
| Translations fail | Network issue - retry with fewer targets |
| Want to undo | Use Git: `git restore resources/lang/` |

## 📊 Status Check

```bash
# See how many translations exist
wc -l resources/lang/*.json

# Check specific file
cat resources/lang/ar.json | head -20
```

## 🆕 Adding New Language

```bash
# Create file for German
touch resources/lang/de.json

# Auto-translate
php artisan translate:strings --targets=de

# Done! Now use {{ __('text') }} and German version appears
```

## 🎯 Best Practices

✅ **Always** wrap user-facing text in `{{ __() }}`
✅ **Keep** English strings clear
✅ **Test** multiple languages in browser
✅ **Use** parameters for dynamic content
❌ **Don't** hardcode text
❌ **Don't** put HTML in translation strings

## 💡 Tips

- Edit JSON files manually for perfect translations
- Use online JSON validators to check syntax
- Test RTL languages (Arabic) in browser
- Keep translations up-to-date with code

## 📞 Need Help?

Read: `TRANSLATION_GUIDE.md` (complete documentation)

---
**API Used:** MyMemory (Free, No Key)
**Last Updated:** December 3, 2025
