APKs.Center — Deploy Package and Run Instructions

This package contains a production-ready deploy archive for the apks.center Laravel app.

Contents and purpose
- `apks.center-deploy-clean-YYYYMMDD.zip` — A clean deploy archive with only the files required for hosting.
- `README_DEPLOY.md` — This file with instructions.
- `scripts/run_php_lint.sh` — Helper script to run `php -l` across the project (requires `php` installed).

How to use
1. Upload and extract on the host
   - Upload `apks.center-deploy-clean-*.zip` to your server and extract at the target path.
   - Ensure the web server document root is pointed at the `public/` directory inside the extracted folder.

2. Install PHP and required extensions
   - Debian/Ubuntu:
     ```bash
     sudo apt update
     sudo apt install -y php-cli php-zip php-mbstring php-xml unzip
     ```
   - CentOS/RHEL:
     ```bash
     sudo yum install -y epel-release
     sudo yum install -y php-cli php-zip php-mbstring php-xml unzip
     ```

3. Install Composer dependencies (if `vendor/` isn't included)
   ```bash
   composer install --no-dev --optimize-autoloader
   ```

4. Configure `.env`
   - Copy `.env.example` to `.env` and set appropriate values (DB, cache, mail, APP_URL).
   - Generate app key:
     ```bash
     php artisan key:generate
     ```

5. Permissions
   ```bash
   chown -R www-data:www-data storage bootstrap/cache
   chmod -R 775 storage bootstrap/cache
   ```

6. Database migrations & seeders (if needed)
   ```bash
   php artisan migrate --force
   php artisan db:seed --force
   ```

7. Cache & routes
   ```bash
   php artisan config:cache
   php artisan route:cache
   ```

8. Run PHP lint across files (optional, recommended)
   ```bash
   bash scripts/run_php_lint.sh
   ```

9. Generate sitemap
   ```bash
   php artisan seo:generate-sitemap
   ```

Notes and troubleshooting
- If `php` is not installed or `sudo` is unavailable, install PHP on your host or contact your host provider to enable it.
- If you omitted `vendor/` from the archive, run `composer install` on the server.
- If you experience permission issues, ensure files are owned by your webserver user.

Security
- Do not commit `.env` to version control.
- Keep backups of the database and the `storage/` folder.

Support
- If you want, I can generate a GitHub Release with the deploy zip as an artifact, or upload the archive to S3 and give you a download link.
