# apks.center — Deployable Laravel APK catalog

This repository is a production-ready Laravel application prepared for direct upload to a host.

What I prepared for you
- `public/build` and `public/vendor` assets are present (no need to rebuild unless you change frontend source).
- `vendor/` is included (dependencies are installed), so the app can run without requiring Composer on the server.
- `deploy-package.tar.gz` (and `deploy-package-final.tar.gz`) is created in the repo root for direct upload.
- `scripts/prepare_deploy.sh` and `scripts/post_deploy.sh` are provided to help finalize setup on the server.
- Formatting configs: `.prettierrc` and `.editorconfig` included.
- CI workflow: `.github/workflows/ci.yml` to run format/build/tests on push/PR.

Quick start (recommended)
1. Upload the contents of the repository (or `deploy-package-final.tar.gz`) to your server.
2. Point your web server document root to the `public/` directory.
3. Copy `.env.example` to `.env` and update values (database, mail, app url).
4. Generate an app key:
   ```bash
   php artisan key:generate
   ```
5. Set permissions (replace `www-data` with your webserver user):
   ```bash
   chown -R www-data:www-data storage bootstrap/cache
   chmod -R 775 storage bootstrap/cache
   ```
6. (Optional) If you want to rebuild assets on the server:
   ```bash
   npm ci
   npm run build
   ```

Post-deploy (run on the server in project root)
```bash
# run the included helper
bash scripts/post_deploy.sh
```

Support & notes
- The `scripts/setup_and_build.sh` file automates tool installation (requires sudo) — run it only on a trusted host.
- I removed local backup duplicates from `resources/views` to keep the repo tidy; originals are preserved in git history.
- If you want me to run a final visual check or migrate inline styles to CSS, tell me and I will prepare that change.

If you'd like, I can produce an archive specifically tailored to a particular host (shared vs VPS) — tell me which target and I'll repackage.
<p align="center"><a href="https://laravel.com" target="_blank"><img src="https://raw.githubusercontent.com/laravel/art/master/logo-lockup/5%20SVG/2%20CMYK/1%20Full%20Color/laravel-logolockup-cmyk-red.svg" width="400" alt="Laravel Logo"></a></p>

<p align="center">
<a href="https://github.com/laravel/framework/actions"><img src="https://github.com/laravel/framework/workflows/tests/badge.svg" alt="Build Status"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/dt/laravel/framework" alt="Total Downloads"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/v/laravel/framework" alt="Latest Stable Version"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/l/laravel/framework" alt="License"></a>
</p>

## About Laravel

Laravel is a web application framework with expressive, elegant syntax. We believe development must be an enjoyable and creative experience to be truly fulfilling. Laravel takes the pain out of development by easing common tasks used in many web projects, such as:

- [Simple, fast routing engine](https://laravel.com/docs/routing).
- [Powerful dependency injection container](https://laravel.com/docs/container).
- Multiple back-ends for [session](https://laravel.com/docs/session) and [cache](https://laravel.com/docs/cache) storage.
- Expressive, intuitive [database ORM](https://laravel.com/docs/eloquent).
- Database agnostic [schema migrations](https://laravel.com/docs/migrations).
- [Robust background job processing](https://laravel.com/docs/queues).
- [Real-time event broadcasting](https://laravel.com/docs/broadcasting).

Laravel is accessible, powerful, and provides tools required for large, robust applications.

## Learning Laravel

Laravel has the most extensive and thorough [documentation](https://laravel.com/docs) and video tutorial library of all modern web application frameworks, making it a breeze to get started with the framework. You can also check out [Laravel Learn](https://laravel.com/learn), where you will be guided through building a modern Laravel application.

If you don't feel like reading, [Laracasts](https://laracasts.com) can help. Laracasts contains thousands of video tutorials on a range of topics including Laravel, modern PHP, unit testing, and JavaScript. Boost your skills by digging into our comprehensive video library.

## Laravel Sponsors

We would like to extend our thanks to the following sponsors for funding Laravel development. If you are interested in becoming a sponsor, please visit the [Laravel Partners program](https://partners.laravel.com).

### Premium Partners

- **[Vehikl](https://vehikl.com)**
- **[Tighten Co.](https://tighten.co)**
- **[Kirschbaum Development Group](https://kirschbaumdevelopment.com)**
- **[64 Robots](https://64robots.com)**
- **[Curotec](https://www.curotec.com/services/technologies/laravel)**
- **[DevSquad](https://devsquad.com/hire-laravel-developers)**
- **[Redberry](https://redberry.international/laravel-development)**
- **[Active Logic](https://activelogic.com)**

## Contributing

Thank you for considering contributing to the Laravel framework! The contribution guide can be found in the [Laravel documentation](https://laravel.com/docs/contributions).

## Code of Conduct

In order to ensure that the Laravel community is welcoming to all, please review and abide by the [Code of Conduct](https://laravel.com/docs/contributions#code-of-conduct).

## Security Vulnerabilities

If you discover a security vulnerability within Laravel, please send an e-mail to Taylor Otwell via [taylor@laravel.com](mailto:taylor@laravel.com). All security vulnerabilities will be promptly addressed.

## License

The Laravel framework is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).
