# APKS Center - Integration Guide

## Quick Start

Follow these steps to integrate the professional design into your Laravel application:

### Step 1: Add CSS to Your Layout

Edit your main layout file (e.g., `resources/views/layouts/app.blade.php`):

```blade
<head>
    <!-- ... existing head content ... -->
    <link rel="stylesheet" href="{{ asset('css/custom.css') }}">
</head>
```

### Step 2: Add JavaScript to Your Layout

Add this before the closing `</body>` tag:

```blade
<script src="{{ asset('js/custom.js') }}"></script>
```

### Step 3: Update Your Navbar

Add the logo to your navbar:

```blade
<a class="navbar-brand" href="{{ url('/') }}">
    <img src="{{ asset('images/logo.svg') }}" alt="APKS Center" style="height: 40px;">
    APKS Center
</a>
```

### Step 4: Use Design Classes

Apply the design classes to your components:

```blade
<!-- Hero Section -->
<section class="hero">
    <div class="container">
        <h1>Welcome to APKS Center</h1>
        <p>Download the latest apps and games</p>
        <button class="btn btn-primary">Start Exploring</button>
    </div>
</section>

<!-- App Cards -->
<div class="card">
    <div class="card-icon"><i class="fas fa-camera"></i></div>
    <h3>Camera Pro</h3>
    <p>Professional camera app</p>
    <button class="btn btn-secondary">Download</button>
</div>
```

## File Locations

```
public/
├── css/
│   └── custom.css          (183 lines)
├── js/
│   └── custom.js           (57 lines)
└── images/
    └── logo.svg            (48 lines)

DESIGN_DOCUMENTATION.md     (125 lines)
INTEGRATION_GUIDE.md        (This file)
```

## Color Reference

```css
--primary: #667eea      /* Purple Blue */
--secondary: #764ba2    /* Deep Purple */
--accent: #ffd700       /* Gold */
--dark: #1a1a2e         /* Dark Background */
--light: #f8f9fa        /* Light Background */
```

## Component Classes

### Buttons
- `.btn-primary` - Gold gradient button
- `.btn-secondary` - Purple gradient button

### Cards
- `.card` - Base card styling
- `.card-icon` - Icon styling

### Sections
- `.hero` - Hero section with gradient
- `.section-title` - Section heading

### Navigation
- `.navbar` - Enhanced navbar
- `.nav-link` - Navigation links

### Footer
- `.footer` - Dark footer
- `.social-links` - Social media links

## JavaScript Features

1. **Smooth Scrolling** - Smooth navigation between sections
2. **Card Animations** - Hover effects on cards
3. **Scroll Animations** - Fade-in animations on scroll
4. **Navbar Effects** - Dynamic shadow on scroll

## Customization

### Change Colors

Edit `public/css/custom.css` and modify the color variables:

```css
:root {
    --primary: #your-color;
    --secondary: #your-color;
    --accent: #your-color;
}
```

### Add More Animations

Edit `public/js/custom.js` to add custom animations.

## Browser Compatibility

✅ Chrome (Latest)
✅ Firefox (Latest)
✅ Safari (Latest)
✅ Edge (Latest)
✅ Mobile Browsers

## Performance Tips

1. Minify CSS and JS in production
2. Use CDN for Font Awesome icons
3. Optimize SVG logo
4. Enable gzip compression
5. Use browser caching

## Troubleshooting

### Styles not applying?
- Clear browser cache (Ctrl+Shift+Delete)
- Run `php artisan cache:clear`
- Check file paths are correct

### JavaScript not working?
- Check browser console for errors
- Ensure jQuery is loaded (if needed)
- Verify file paths

### Logo not showing?
- Check SVG file exists at `public/images/logo.svg`
- Verify image path in HTML
- Check file permissions

## Support

For issues or questions, refer to:
- DESIGN_DOCUMENTATION.md
- Browser Developer Tools (F12)
- Laravel Documentation

---
Designed with precision and professionalism for APKS Center
