Deployment checklist — Preparing this repo for upload to a shared host

This repository has been prepared so it can be uploaded to a hosting server (shared or VPS). Follow these steps on the target host after uploading/extracting the project files.

1) Place files
   - Upload the contents of this repository to your server, ideally under `/var/www/your-site` or similar.
   - Ensure the web server's document root points to the `public/` directory.

2) Install server dependencies (on the server)
   - PHP 8.2+ and required extensions: `mbstring`, `xml`, `zip`, `curl`, `gd` or `imagick` if you use image processing.
   - Composer (recommended): https://getcomposer.org

   Example (Debian/Ubuntu):
   ```bash
   sudo apt update
   sudo apt install -y php-cli php-xml php-mbstring php-zip unzip curl
   curl -sS https://getcomposer.org/installer | php
   sudo mv composer.phar /usr/local/bin/composer
   ```

3) Install PHP dependencies
   ```bash
   cd /path/to/your/app
   composer install --no-dev --optimize-autoloader
   ```

4) If you need to rebuild frontend assets (optional)
   - Node.js (v18+) and npm installed on the server.
   - Run:
     ```bash
     npm ci
     npm run build
     ```
   Notes: This project already includes `public/build` assets. Rebuild only if you change JS/CSS.

5) Set environment and permissions
   - Copy the example file and update values: `cp .env.example .env` and set `APP_KEY`, DB credentials, etc.
   - Generate an application key:
     ```bash
     php artisan key:generate
     ```
   - Set storage and cache permissions (web server user, e.g. `www-data`):
     ```bash
     chown -R www-data:www-data storage bootstrap/cache
     chmod -R 775 storage bootstrap/cache
     ```

6) Optimize framework (recommended for production)
   ```bash
   php artisan config:cache
   php artisan route:cache
   php artisan view:cache
   php artisan optimize
   ```

7) (Optional) Run database migrations and seeders
   ```bash
   php artisan migrate --force
   php artisan db:seed --class=AppSeeder --force
   ```

8) After deploy: clear caches if you change configuration or routes
   ```bash
   php artisan config:clear
   php artisan cache:clear
   php artisan route:clear
   php artisan view:clear
   ```

9) Troubleshooting
   - 500 errors: check `storage/logs/laravel.log` and the web server error log.
   - Permissions: ensure `storage` and `bootstrap/cache` are writable by the web server.

If you want, I can produce a zip/tar of the current repository with vendor and public/build included for direct upload. Tell me to "Create deploy archive" and I'll generate it (it may be large).
